/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.cloud.storage.BufferHandle;
import com.google.cloud.storage.BufferedWritableByteChannelSession;
import com.google.cloud.storage.Buffers;
import com.google.cloud.storage.UnbufferedWritableByteChannelSession;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;

final class DefaultBufferedWritableByteChannel
implements BufferedWritableByteChannelSession.BufferedWritableByteChannel {
    private final BufferHandle handle;
    private final UnbufferedWritableByteChannelSession.UnbufferedWritableByteChannel channel;
    private final boolean blocking;

    DefaultBufferedWritableByteChannel(BufferHandle handle, UnbufferedWritableByteChannelSession.UnbufferedWritableByteChannel channel) {
        this(handle, channel, true);
    }

    DefaultBufferedWritableByteChannel(BufferHandle handle, UnbufferedWritableByteChannelSession.UnbufferedWritableByteChannel channel, boolean blocking) {
        this.handle = handle;
        this.channel = channel;
        this.blocking = blocking;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        if (!this.channel.isOpen()) {
            throw new ClosedChannelException();
        }
        int bytesConsumed = 0;
        while (src.hasRemaining()) {
            int srcRemaining = src.remaining();
            int srcPosition = src.position();
            int capacity = this.handle.capacity();
            int bufferRemaining = this.handle.remaining();
            int bufferPending = capacity - bufferRemaining;
            boolean enqueuedBytes = this.enqueuedBytes();
            if (srcRemaining < bufferRemaining) {
                ((ByteBuffer)this.handle.get()).put(src);
                bytesConsumed += srcRemaining;
                break;
            }
            if (enqueuedBytes) {
                ByteBuffer buf;
                int sliceLimit = bufferRemaining;
                boolean usingSlice = false;
                if (srcRemaining == bufferRemaining) {
                    buf = src;
                } else {
                    ByteBuffer slice = src.slice();
                    Buffers.limit(slice, sliceLimit);
                    usingSlice = true;
                    buf = slice;
                }
                ByteBuffer buffer = (ByteBuffer)this.handle.get();
                Buffers.flip(buffer);
                ByteBuffer[] srcs = new ByteBuffer[]{buffer, buf};
                long write = this.channel.write(srcs);
                Preconditions.checkState((write >= 0L ? 1 : 0) != 0, (String)"write >= 0 (%s > 0)", (long)write);
                if (write == (long)capacity) {
                    Buffers.clear(buffer);
                    if (usingSlice) {
                        Buffers.position(src, srcPosition + sliceLimit);
                    }
                    bytesConsumed += sliceLimit;
                    continue;
                }
                if (buffer.hasRemaining()) {
                    buffer.compact();
                } else {
                    Buffers.clear(buffer);
                    int sliceWritten = Math.toIntExact(write - (long)bufferPending);
                    Buffers.position(src, srcPosition + sliceWritten);
                    bytesConsumed += sliceWritten;
                }
                if (this.blocking) continue;
                break;
            }
            if (bufferRemaining == srcRemaining) {
                int write = this.channel.write(src);
                Preconditions.checkState((write >= 0 ? 1 : 0) != 0, (String)"write >= 0 (%s > 0)", (int)write);
                bytesConsumed += write;
                if (write >= srcRemaining || this.blocking) continue;
                break;
            }
            ByteBuffer slice = src.slice();
            Buffers.limit(slice, bufferRemaining);
            int write = this.channel.write(slice);
            Preconditions.checkState((write >= 0 ? 1 : 0) != 0, (String)"write >= 0 (%s > 0)", (int)write);
            int newPosition = srcPosition + write;
            Buffers.position(src, newPosition);
            bytesConsumed += write;
            if (write >= bufferRemaining || this.blocking) continue;
            break;
        }
        return bytesConsumed;
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public void close() throws IOException {
        if (this.enqueuedBytes()) {
            ByteBuffer buffer = (ByteBuffer)this.handle.get();
            Buffers.flip(buffer);
            this.channel.writeAndClose(buffer);
            if (buffer.hasRemaining()) {
                buffer.compact();
            } else {
                Buffers.clear(buffer);
            }
        } else {
            this.channel.close();
        }
    }

    @Override
    public void flush() throws IOException {
        while (this.enqueuedBytes()) {
            ByteBuffer buffer = (ByteBuffer)this.handle.get();
            Buffers.flip(buffer);
            this.channel.write(buffer);
            if (buffer.hasRemaining()) {
                buffer.compact();
                continue;
            }
            Buffers.clear(buffer);
        }
    }

    private boolean enqueuedBytes() {
        return this.handle.position() > 0;
    }
}

